#!/bin/bash

PROJECT="Instamic Firmware Upgrade.xcodeproj"
DESTINATION="generic/platform=macOS"

# Get a list of all schemes, then build each.
xcodebuild -project "${PROJECT}" -list | \
    sed -n '/Schemes/,/^$/p' | \
    grep -v "Schemes:" | \
    while read scheme; do
        if [ -n "${scheme}" ]; then
            echo "Building ${scheme}…"

            build_dir="$(pwd)/build"
            archivePath="${build_dir}/Archives/${scheme}.xcarchive"
            exportPath="${build_dir}/${scheme}"

            xcodebuild -project "${PROJECT}" \
                -scheme "${scheme}" \
                -destination "${DESTINATION}" \
                archive \
                -archivePath "${archivePath}" || exit $?

            xcodebuild -exportArchive \
                -archivePath "${archivePath}" \
                -exportPath "${exportPath}" \
                -exportOptionsPlist exportOptions.plist || exit $?
        fi
    done

zip -r "Instamic Firmware Upgrade $(date +"%Y%m%d%H%M%S").zip" build/*/*.app

